<?
/*
	Transao de incluso/alterao de registros
*/
include("../inc/common.php");

/*
	verificao do nvel do usurio
*/
verificaPermissao("10,1");

/*
	conexo com o banco de dados
*/
$conn = new db();
$conn->open();

/*
	tratamento de campos,
	configure conforme sua necessidade,
	siga o exemplo abaixo
*/
$data_cadastro = dtos(getParam("f_data_cadastro"));
$ativo         = strlen(getParam("f_ativo"))==0?"0":getParam("f_ativo");
$descricao     = addslashes(getParam("f_descricao"));

/*
	validao,
	coloque aqui estruturas condicionais que
	alimentem o objeto Erro. siga o exemplo abaixo.
*/
$erro = new Erro();
if (getParam("f_nome_usuario")=="")          $erro->addErro('Nome de usurio deve ser informado.');
if (getParam("f_senha")=="")                 $erro->addErro('Senha deve ser informada.');
if (strlen(getParam("f_senha"))<6)           $erro->addErro('Senha deve ter 6 ou mais caracteres.');
if (isDuplicated("usuario", "nome_usuario", "usuario_id", getParam("f_nome_usuario"), getParam("f_id"))) $erro->addErro('Nome de usurio j existe.');
if (!ereg(REGEX_EMAIL, getParam("f_email"))) $erro->addErro('Endereo de e-mail invlido.');

/*
	Atualizao dos dados, configure abaixo
	conforme suas necessidades
*/
if (!$erro->hasErro()) { // passou na validao
	// objeto para montagem de expresso sql
	$sql = new UpdateSQL();
	
	$sql->setTable("usuario");
	$sql->setKey("usuario_id",          getParam("f_id"),              "Number");
	
	$sql->addField("data_cadastro",     $data_cadastro,                "Date");
	$sql->addField("nome_usuario",      getParam("f_nome_usuario"),    "String");
	$sql->addField("senha",             getParam("f_senha"),           "String");
	$sql->addField("nivel_acesso",      getParam("f_nivel_acesso"),    "Number");
	$sql->addField("nome_real",         getParam("f_nome_real"),       "String");
	$sql->addField("departamento_id",   getParam("f_departamento_id"), "Number");
	$sql->addField("email",             getParam("f_email"),           "String");
	$sql->addField("descricao",         $descricao,                    "String");
	$sql->addField("ativo",             $ativo,                        "Number");
	
	if (strlen(getParam("f_id"))>0) { // alterao, retirar strlen se vier de edicao_aux
		$sql->setAction("UPDATE");
   $sql->camposControle("UPDATE",dbnow());
		$conn->execute($sql->getSQL());
		$destino = "../content/objeto_lista.php"; 
	} else { // incluso
		$sql->setAction("INSERT");
		$sql->camposControle("INSERT",dbnow());
		$last_id = $conn->execute($sql->getSQL());
		$destino = "../content/objeto_edicao.php?id=$last_id";
	}
	
	// volta para a lista ou reapresenta o formulrio em modo de edio
	redirect($destino,"content");
} else { // no passou na validao
	alert('Ocorreram os seguintes erros!\n\n'.$erro->toString());
}
/*
	Encerra a conexo com o banco de dados
*/
$conn->close();
?>