<?
/*
	Modelo de pgina que apresenta uma lista de registros
*/
include("../inc/common.php");


/*
	verificao do nvel do usurio, altere conforme sua necessidade, quanto maior o valor,
	maior a restrio
*/
verificaPermissao("10,1");


/*
	conexo com o banco de dados, altere somente se a conexo for diferente do default
*/
$conn = new db();
$conn->open();


/*
	determina a pgina a ser exibida, no precisa alterar
*/
$pg = getParam("pagina");
if ($pg == "") $pg = 1;


/*
	Limpa ordenao e filtro, no deve ser alterado
*/
if (getParam("clear")==1) {
	setSession("sOrder","");
	setSession("where","");
	setSession("pagina_atual","");
}

/*
	Salva o status da pgina atual, no deve ser alterado
*/
if ($_SERVER['PHP_SELF'] != $pagina_atual) {
	$mesma_pagina = false;
	setSession("pagina_atual",$_SERVER['PHP_SELF']);
} else {
	$mesma_pagina = true;
}


/*
	construo da ordenao
*/
$iSort = getParam("Sorting");
$iSorted = getParam("Sorted");
if ((!$iSort)&&(!$mesma_pagina)) {
	$form_sorting = "";
	$iSort = 2; // configure a ordenao inicial da lista de acordo com as colunas da tabela 
	$iSorted = ""; // se a ordenao estiver DESCENDENTE, repita o mesmo valor abaixo
}
if ($iSort) {
	if ($iSort == $iSorted) {
		$form_sorting = "";
		$sDirection = " DESC";
		$sSortParams = "Sorting=" . $iSort . "&Sorted=" . $iSort . "&";
	} else {
		$form_sorting = $iSort;
		$sDirection = " ASC";
		$sSortParams = "Sorting=" . $iSort . "&Sorted=" . "&";
	}
	/*
		coloque aqui a definio das ordenaes das colunas de acordo com as colunas da tabela
	*/
	if ($iSort == 2) setSession("sOrder"," order by usuario.nome_usuario" . $sDirection); 
	if ($iSort == 3) setSession("sOrder"," order by usuario.nome_real" . $sDirection);
	if ($iSort == 4) setSession("sOrder"," order by usuario.nivel_acesso" . $sDirection);
	if ($iSort == 5) setSession("sOrder"," order by departamento.nome_departamento" . $sDirection);
}



if (getParam("rodou")=="s") { // se ocorreu pesquisa...
	$onde = "";
	/*
		construa a string WHERE conforme o exemplo abaixo
	*/
	if (getParam("pesq_nome_usuario") != "") $onde .= "AND usuario.nome_usuario LIKE '%" . getParam("pesq_nome_usuario") . "%'";
	if (getParam("pesq_nome_real") != "") $onde .= "AND usuario.nome_real LIKE '%" . getParam("pesq_nome_real") . "%'";
	if (getParam("pesq_departamento_id") != "") $onde .= "AND usuario.departamento_id = " . getParam("pesq_departamento_id") . "";
	setSession("where",$onde);
}

/*
	flag pra informar se o filtro est ou no ativo
*/
if (strlen(getSession("where"))>0) {
	$filtrado = FILTRO_ATIVO;
} else {
	$filtrado = "";
}


/*
	expresso SQL que define a lista, construa livremente observando a concatenao com as
	sessions WHERE e sOrder, conforme exemplo abaixo
*/
$sql = "SELECT usuario.*, departamento.nome_departamento "
     . "FROM usuario, departamento "
     . "WHERE usuario.departamento_id=departamento.departamento_id " . getSession("where") . getSession("sOrder");
	  

/*
	criao do recordset, altere somente o ltimo parmetro que	corresponde a quantidade de
	registros por pgina
*/
$rs = new query($conn, $sql, $pg, 10);
?>
<html>
<head>
	<title>objeto-listapesquisa</title>
	<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
	<link rel="stylesheet" type="text/css" href="<?=CSS_CONTENT?>">
	<script language="javascript" src="../inc/js/checkall.js"></script>
	<script language="JavaScript">
	/*
		funo que chama a rotina de excluso de registros, altere somente o nome da pgina
		a ser chamada
	*/
	function excluir() {
		if (confirm('Excluir registros selecionados?')) {
			parent.content.document.frm.target = "controle";
			parent.content.document.frm.action = "../content/objeto_excluir.php";
			parent.content.document.frm.submit();
		}
	}
	
	/*
		funo de exemplo para chamar um processamento qualquer
	*/
	function processar() {
		if (confirm('Processar registros selecionados?')) {
			parent.content.document.frm.target = "controle";
			parent.content.document.frm.action = "../content/objeto_processar.php";
			parent.content.document.frm.submit();
		}
	}
	

	/*
		funo que chama a pgina de lista ou relatrio,
		enviando os parmetros de pesquisa,
		altere somente o nome da pgina
	*/
	function pesquisar() {
		parent.content.document.frmPesquisa.target = "content";
		parent.content.document.frmPesquisa.action = "../content/objeto_listapesquisa.php";
		parent.content.document.frmPesquisa.submit();
	}
	
	/*
		funo que define o foco inicial do formulrio
	*/
	function inicializa() {
		if (document.captureEvents && Event.KEYUP) {
			document.captureEvents( Event.KEYUP);
		}
		document.onkeyup = trataEvent;

		// inicia o foco no primeiro campo
		parent.content.document.frmPesquisa.pesq_nome_usuario.focus();
	}

	/*
		tratamento para capturar tecla enter
	*/
	function trataEvent(e) {
		if( !e ) { //verifica se  IE
			if( window.event ) {
				e = window.event;
			} else {
				//falha, no tem como capturar o evento
				return;
			}
		}
		if( typeof( e.keyCode ) == 'number'  ) { //IE, NS 6+, Mozilla 0.9+
			e = e.keyCode;
		} else {
			//falha, no tem como obter o cdigo da tecla
			return;
		}
		if (e==13) {
			pesquisar();
		}
	}

	</script>
</head>
<body class="contentBODY">

<?
pageTitle("Objeto","Pesquisa");

/*
	botes de aes,
	configure conforme sua necessidade
*/
$buttonPesq = new Button;
$buttonPesq->addItem(" Ok ","javascript:pesquisar()");
echo $buttonPesq->writeHTML();
?>
<br>
<?
/*
	formulrio de pesquisa
*/
$form = new Form("frmPesquisa");
$form->setMethod("POST");
$form->setTarget("content");
$form->setWidth("100%");
$form->setLabelWidth("20%");
$form->setDataWidth("80%");

$form->addHidden("rodou","s");
$form->addField("Nome do usurio: ", textField("pesq_nome_usuario","",20,20));
$form->addField("Nome real: ",       textField("pesq_nome_real","",50,50));
$sql = "SELECT departamento_id as id, nome_departamento as val FROM departamento ORDER BY nome_departamento";
$form->addField("Departamento: ",    listboxField($sql, "pesq_departamento_id",0, "Todos"));
echo $form->writeHTML();

pageTitle("","Lista");


/*
	botes de aes
*/
$button = new Button;
/*
	botes de navegao da lista, no deve ser alterada
*/
$pg_ant = $pg-1;
$pg_prox = $pg+1;
if ($pg>1)                 $button->addItem(LISTA_ANTERIOR,$_SERVER['PHP_SELF']."?pagina=$pg_ant" ,"content");
if ($pg<$rs->totalpages()) $button->addItem(LISTA_PROXIMO ,$_SERVER['PHP_SELF']."?pagina=$pg_prox","content");

/*
	botes de aes da lista, altere conforme suas necessidades
*/
$button->addItem("Novo Objeto","../content/objeto_edicao.php","content");
$button->addItem("Excluir","javascript:excluir()","content");
$button->addItem("Processar","javascript:processar()","content",3);
$button->addItem("Imprimir","../content/objeto_imprimir.php","controle");
echo $button->writeHTML();
?>

<!-- Lista -->
<div align="center">
<form name="frm" method="post">
<?
/*
	inicializao da tabela
*/
$table = new Table("","100%",6); // Ttulo, Largura, Quantidade de colunas

/*
	Configurao das colunas da tabela
*/
$table->addColumnHeader("<input type=\"checkbox\" name=\"checkall\" onclick=\"CheckAll()\">"); // Coluna com checkbox
$table->addColumnHeader("Usurio",true,"25%"); // Ttulo, Ordenar?, Largura
$table->addColumnHeader("Nome Real",true,"35%");
$table->addColumnHeader("Nivel",true,"10%","C");
$table->addColumnHeader("Departamento",true,"20%");
$table->addColumnHeader("Ativo",false,"10%","C");
$table->addRow(); // adiciona linha (TR)

while ($rs->getrow()) {
	$id = $rs->field("usuario_id"); // captura a chave primria do recordset
	
	// exemplo do mtodo addBreak
	if (($rs->field("nome_departamento")!=$ult_cat)&&(strpos(getSession("sOrder"),"departamento"))) {
		$table->addBreak("<b>Departamento: " . $rs->field("nome_departamento")."</b>");
		$ult_cat = $rs->field("nome_departamento");
	}
	
	$table->addData("<input type=\"checkbox\" name=\"sel[]\" value=\"$id\">");
	$table->addData(addLink($rs->field("nome_usuario"),"../content/objeto_edicao.php?id=$id&pagina=$pg","Clique para consultar ou editar registro"));
	$table->addData($rs->field("nome_real"));
	$table->addData($rs->field("nivel_acesso"),"C");
	$table->addData($rs->field("nome_departamento"));
	$table->addData($rs->field("ativo")==1?"Sim":"No","C");
	$table->addRow();
}

echo "<div class='DataFONT' align='right'><b>$filtrado</b></div>";

/*
	Desenha a tabela
*/
if ($rs->numrows()>0) {
	echo $table->writeHTML();
	echo "<div class='DataFONT'>Pgina ".$pg." de ".$rs->totalpages()."</div>";
} else {
	echo "<div class='DataFONT'>Nenhum registro encontrado!</div>";
}
?>
</form>
</div>

</body>
</html>
<?
/*
	fecha a conexo com o banco de dados, no deve ser alterado
*/
$conn->close();
?>