<?
/*
	Modelo de pgina que apresenta uma lista encadeada de registros
*/
include("../inc/common.php");


/*
	verificao do nvel do usurio, altere conforme sua necessidade, quanto maior o valor,
	maior a restrio
*/
verificaUsuario(1);


/*
	conexo com o banco de dados, altere somente se a conexo for diferente do default
*/
$conn = new db();
$conn->open();


/*
	determina a pgina a ser exibida, no precisa alterar
*/
$pg = getParam("pagina");
if ($pg == "") $pg = 1;


/*
	Limpa ordenao e filtro, no deve ser alterado
*/
if (getParam("clear")==1) {
	setSession("sOrder","");
	setSession("where","");
	setSession("pagina_atual","");
}

/*
	Salva o status da pgina atual, no deve ser alterado
*/
if ($_SERVER['PHP_SELF'] != $pagina_atual) {
	$mesma_pagina = false;
	setSession("pagina_atual",$_SERVER['PHP_SELF']);
} else {
	$mesma_pagina = true;
}


/*
	construo da ordenao
*/
$iSort = getParam("Sorting");
$iSorted = getParam("Sorted");
if ((!$iSort)&&(!$mesma_pagina)) {
	$form_sorting = "";
	$iSort = 2; // configure a ordenao inicial da lista de acordo com as colunas da tabela 
	$iSorted = ""; // se a ordenao estiver DESCENDENTE, repita o mesmo valor abaixo
}
if ($iSort) {
	if ($iSort == $iSorted) {
		$form_sorting = "";
		$sDirection = " DESC";
		$sSortParams = "Sorting=" . $iSort . "&Sorted=" . $iSort . "&";
	} else {
		$form_sorting = $iSort;
		$sDirection = " ASC";
		$sSortParams = "Sorting=" . $iSort . "&Sorted=" . "&";
	}
	/*
		coloque aqui a definio das ordenaes das colunas de acordo com as colunas da tabela
	*/
	if ($iSort == 2) setSession("sOrder"," order by usuario.nome_usuario" . $sDirection); 
	if ($iSort == 3) setSession("sOrder"," order by usuario.nome_real" . $sDirection);
	if ($iSort == 4) setSession("sOrder"," order by usuario.nivel_acesso" . $sDirection);
	if ($iSort == 5) setSession("sOrder"," order by departamento.nome_departamento" . $sDirection);
}


/*
	construo da pesquisa
*/
if (getParam("rodou")=="s") { // se ocorreu pesquisa...
	$onde = "";
	// construa a string WHERE conforme o exemplo abaixo
	if (getParam("pesq_nome_usuario") != "") $onde .= "AND usuario.nome_usuario LIKE '%" . getParam("pesq_nome_usuario") . "%'";
	if (getParam("pesq_nome_real") != "") $onde .= "AND usuario.nome_real LIKE '%" . getParam("pesq_nome_real") . "%'";
	if (getParam("pesq_departamento_id") != "") $onde .= "AND usuario.departamento_id = " . getParam("pesq_departamento_id") . "";
	setSession("where",$onde);
}

/*
	flag pra informar se o filtro est ou no ativo
*/
if (strlen(getSession("where"))>0) {
	$filtrado = FILTRO_ATIVO;
} else {
	$filtrado = "";
}


/*
	expresso SQL que define a lista, construa livremente observando a concatenao com as
	sessions WHERE e sOrder, conforme exemplo abaixo
*/
$sql = "SELECT usuario.*, departamento.nome_departamento "
     . "FROM usuario, departamento "
     . "WHERE usuario.departamento_id=departamento.departamento_id " . getSession("where") . getSession("sOrder");
	  

/*
	criao do recordset, altere somente o ltimo parmetro que	corresponde a quantidade de
	registros por pgina
*/
$rs = new query($conn, $sql, $pg, 10);
?>
<html>
<head>
	<title>objeto-listaencadeada</title>
	<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
	<link rel="stylesheet" type="text/css" href="<?=CSS_CONTENT?>">
	<script language="javascript" src="../inc/js/checkall.js"></script>
	
	<script language="JavaScript">
	/*
		funo que chama a rotina de excluso de registros, altere somente o nome da pgina
		a ser chamada
	*/
	function excluir() {
		if (confirm('Excluir registros selecionados?')) {
			parent.content.document.frm.target = "controle";
			parent.content.document.frm.action = "../content/objeto_excluir.php";
			parent.content.document.frm.submit();
		}
	}
	
	/*
		funo de exemplo para chamar um processamento qualquer
	*/
	function processar() {
		if (confirm('Processar registros selecionados?')) {
			parent.content.document.frm.target = "controle";
			parent.content.document.frm.action = "../content/objeto_processar.php";
			parent.content.document.frm.submit();
		}
	}
	
	/*
		funo para controlar a exibio da lista encadeada
	*/
	function openList(key) {
		var oKey = parent.content.document.getElementById(key);
		var icone = parent.content.document.getElementById('fold_'+key);
		if (oKey.style.visibility == "hidden"){
			oKey.style.visibility = "visible";
			oKey.style.display = "block";
			icone.innerHTML = "&nbsp;-&nbsp;";
			
		} else {
			oKey.style.visibility = "hidden";
			oKey.style.display = "none";
			icone.innerHTML = "&nbsp;+&nbsp;";
		}
	}
	</script>
</head>
<body class="contentBODY">

<?
pageTitle("Objeto","Lista Encadeada");

/*
	botes de aes
*/
$button = new Button;

/*
	botes de navegao da lista, no deve ser alterada
*/
$pg_ant = $pg-1;
$pg_prox = $pg+1;
if ($pg>1)                 $button->addItem(LISTA_ANTERIOR,$_SERVER['PHP_SELF']."?pagina=$pg_ant" ,"content");
if ($pg<$rs->totalpages()) $button->addItem(LISTA_PROXIMO ,$_SERVER['PHP_SELF']."?pagina=$pg_prox","content");

/*
	botes de aes da lista, altere conforme suas necessidades
*/
$button->addItem("Novo Objeto","../content/objeto_edicao.php","content");
$button->addItem("Pesquisa","../content/objeto_pesquisa.php","content");
$button->addItem("Excluir","javascript:excluir()","content");
$button->addItem("Processar","javascript:processar()","content",3);
$button->addItem("Imprimir","../content/objeto_imprimir.php","controle");
echo $button->writeHTML();
?>

<!-- Lista -->
<div align="center">
<form name="frm" method="post">
<?
/*
	inicializao da tabela
*/
$table = new Table("","100%",7); // Ttulo, Largura, Quantidade de colunas

/*
	Configurao das colunas da tabela
*/
$table->addColumnHeader("<input type=\"checkbox\" name=\"checkall\"onclick=\"CheckAll()\">"); // Coluna com checkbox
$table->addColumnHeader("<acronym title='Exibio dos histricos dos usurios'>&nbsp;+&nbsp;</acronym>");
$table->addColumnHeader("Usurio",true,"25%", "L"); // Ttulo, Ordenar?, Largura, Alinhamento
$table->addColumnHeader("Nome Real",true,"35%","L");
$table->addColumnHeader("Nivel",true,"10%","C");
$table->addColumnHeader("Departamento",true,"20%","L");
$table->addColumnHeader("Ativo",false,"10%","C");
$table->addRow(); // adiciona linha (TR)

while ($rs->getrow()) {
	$id = $rs->field("usuario_id"); // captura a chave primria do recordset
	
	// defino da lista encadeada
	$sqlHistorico = "SELECT * FROM historico WHERE usuario_id=".$id." ORDER BY data_cadastro DESC";
	$rsHistorico = new query($conn, $sqlHistorico);
	$table_encadeada = new Table("","100%",2);
	$table_encadeada->addColumnHeader("Data",false,"20%", "L");
	$table_encadeada->addColumnHeader("Descrio",false,"80%","L");
	$table_encadeada->addRow();
	while ($rsHistorico->getrow()) {
		$table_encadeada->addData(stod($rsHistorico->field("data_cadastro")));
		$table_encadeada->addData($rsHistorico->field("descricao"));
		$table_encadeada->addRow();
	}


	// definio da lista principal
	$table->addData("<input type=\"checkbox\" name=\"sel[]\" value=\"$id\">");
	if ($rsHistorico->numrows()>0) {
		$table->addData("<span id='fold_$id' style='cursor: pointer' onClick=\"javascript:openList('$id')\">&nbsp;+&nbsp;</span>","C");
	} else {
		$table->addData("&nbsp;");
	}
	$table->addData(addLink($rs->field("nome_usuario"),"../content/objeto_edicao.php?id=$id&pagina=$pg","Clique para consultar ou editar registro"));
	$table->addData($rs->field("nome_real"));
	$table->addData($rs->field("nivel_acesso"),"C");
	$table->addData($rs->field("nome_departamento"));
	$table->addData($rs->field("ativo")==1?"Sim":"No","C");
	$table->addRow();
	
	// exibe lista encadeada
	if ($rsHistorico->numrows()>0) {
		$table->addBreak("<div id=\"$id\" style='visibility: hidden; display: none; margin-left: 60px'>".$table_encadeada->writeHTML()."</div>", false);
	}
	
}

echo "<div class='DataFONT' align='right'><b>$filtrado</b></div>";

/*
	Desenha a tabela
*/
if ($rs->numrows()>0) {
	echo $table->writeHTML();
	echo "<div class='DataFONT'>Pgina ".$pg." de ".$rs->totalpages()."</div>";
} else {
	echo "<div class='DataFONT'>Nenhum registro encontrado!</div>";
}
?>
</form>
</div>

</body>
</html>
<?
/*
	fecha a conexo com o banco de dados, no deve ser alterado
*/
$conn->close();
?>