<?
/*
	Modelo de pgina que apresenta uma lista de registros em relacionamentos 1:N
*/
include("../inc/common.php");

/*
	verificao do nvel do usurio
*/
verificaPermissao("10,1");

/*
	conexo com o banco de dados
*/
$conn = new db();
$conn->open();

/*
	se a lista faz parte de um relacionamento 1:N
*/
$relacionamento_id = getParam("id");

/*
	determina a pgina a ser exibida
*/
$pg = getParam("pagina");
if ($pg == "") $pg = 1;

/*
	expresso SQL que define a lista, configure conforme sua necessidade
*/
$sql = "SELECT * " .
       "FROM historico " .
		 "WHERE usuario_id=$relacionamento_id " .
		 "ORDER BY data_cadastro DESC";
	  
/*
	criao do recordset, o ltimo parmetro corresponde a quantidade de registros por pgina
*/
$rs = new query($conn, $sql, $pg, 10);
?>
<html>
<head>
	<title>objeto-lista-1N</title>
	<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
	<link rel="stylesheet" type="text/css" href="<?=CSS_CONTENT?>">
	<script language="JavaScript" src="../inc/js/janela.js"></script>
	<script language="javascript" src="../inc/js/checkall.js"></script>
	<script language="JavaScript">
	/*
		funo que chama a rotina de excluso,
		altere somente o nome da pgina (action)
	*/
	function excluir() {
		if (confirm('Excluir registros selecionados?')) {
			parent.content.document.frm.target = "controle";
			parent.content.document.frm.action = "#";
			parent.content.document.frm.submit();
		}
	}
	
	function abreEdicao(id) {
		// ateno, o separador "&" deve ser substituido por vrgula ","
		abreJanelaAuxiliar('../content/objeto_edicao_aux.php?relacionamento_id=<?=$relacionamento_id?>,id=' + id); 
	} 
	</script>
</head>
<body class="contentBODY">

<?
pageTitle("Objeto","Lista de ocorrncias do objeto");

/*
	botes de aes
*/
$button = new Button;

/*
	botes de navegao, no deve ser alterado
*/
$pg_ant = $pg-1;
$pg_prox = $pg+1;
if ($pg>1)                 $button->addItem(LISTA_ANTERIOR,$_SERVER['PHP_SELF']."?pagina=$pg_ant&id=$relacionamento_id" ,"content");
if ($pg<$rs->totalpages()) $button->addItem(LISTA_PROXIMO ,$_SERVER['PHP_SELF']."?pagina=$pg_prox&id=$relacionamento_id","content");

/*
	botes de aes, configure conforme sua necessidade
*/
$button->addItem("Novo Relacionamento","javascript:abreEdicao(0)","content");
$button->addItem("Excluir","javascript:excluir()","content");
echo $button->writeHTML();

/*
	Controle de abas, true, se for a aba da pgina atual, false, se for qualquer outra aba,
	configure conforme o exemplo abaixo
*/
$abas = new Abas();
$abas->addItem("Geral",false,"../content/objeto_edicao.php?id=$relacionamento_id");
$abas->addItem("Associao",false,"../content/objeto_associacao.php?id=$relacionamento_id");
$abas->addItem("Ordenao",false,"../content/objeto_ordenacao.php?id=$relacionamento_id");
$abas->addItem("Detalhe",false,"../content/objeto_consulta.php?id=$relacionamento_id");
$abas->addItem("Lista 1:N",true);
echo $abas->writeHTML();
?>


<!-- Lista -->
<div align="center">
<form name="frm" method="post">
<input type="hidden" name="relacionamento_id" value="<?=$relacionamento_id?>">
<?
/*
	inicializao da tabela
*/
$table = new Table("Ttulo da Lista","100%",3); // Ttulo, Largura, Quantidade de colunas

/*
	construo dos cabealhos da tabela
*/
$table->addColumnHeader("<input type=\"checkbox\" name=\"checkall\" onclick=\"CheckAll()\">");
$table->addColumnHeader("Data",false,"15%"); // Ttulo, Ordenar?, Largura
$table->addColumnHeader("Descrio",false,"85%");
$table->addRow();

while ($rs->getrow()) {
	$id = $rs->field("historico_id"); // captura chave primria
	
	/*
		adiciona colunas
	*/
	$table->addData("<input type=\"checkbox\" name=\"sel[]\" value=\"$id\">");
	$table->addData(stod($rs->field("data_cadastro")));
	$table->addData(addLink($rs->field("descricao"),"javascript:abreEdicao($id)","Clique para consultar ou editar registro"));

	$table->addRow(); // adiciona linha
}

/*
	Desenha a tabela
*/
if ($rs->numrows()>0) {
	echo $table->writeHTML();
	echo "<div class='DataFONT'>Pgina ".$pg." de ".$rs->totalpages()."</div>";
} else {
	echo "<div class='DataFONT'>Nenhum registro encontrado!</div>";
}
?>

</form>
</div>

</body>
</html>
<?
/*
	fecha a conexo com o banco de dados
*/
$conn->close();
?>