<?
include("../inc/common.php");

/*
	classe para a manipulao de elementos PDF
*/
require("../inc/pdf/fpdf.php");
define('FPDF_FONTPATH','../inc/pdf/font/');

/*
	verifica se o usurio pode acessar esta pgina
*/
verificaPermissao("10,1");

/*
	conexo com o banco de dados
*/
$conn = new db();
$conn->open();

/*
	definio de cabealho e rodap (extendendo a classe FPDF),
	configure conforme a sua necessidade
*/
class PDF extends FPDF {
	function Header() {
		$this->SetFont('Arial','B',14);
		$this->Cell(50,6,"Nome do Sistema",0,0);
		
		$this->SetFont('Arial','I',8);
		$this->Cell(0,6,"Identificao do relatrio",0,1,"R");
		
		$this->SetFont('Arial','B',14);
		$this->Cell(0,6,"Ttulo do relatrio","B");
		
		$this->Ln(10);
		$this->SetFont('Arial','B',10);
		$this->Cell(70,4,"Nome de usurio",0,0,"L");
		$this->Cell(35,4,"Departamento",0,0,"L");
		$this->Cell(0,4,"Descrio",0,1,"L");

	}
	
	function Footer() {
		$this->SetY(-15);
		$this->SetFont('Arial','I',8);
		$this->Cell(10,10,"","T"); $this->Cell(30,10,date("d/m/Y - H:i"),"T",0,'L');
		$this->Cell(0,10,'Pgina '.$this->PageNo(),"T",0,'R');
	}
}

/*
	cria documento
*/
$pdf=new PDF("P","mm","A4");
$pdf->setAuthor("PROCERGS");
$pdf->setTitle("Nome do relatrio");
$pdf->setCreator("PHP/FPDF 1.51");

/*
	abre documento
*/
$pdf->Open();

/*
	primeira pgina (as demais so automticas)
*/
$pdf->AddPage();

/*
	fonte padro
*/ 
$pdf->SetFont('Arial','',9);

/*
	expresso SQL responsvel pela iterao,
	configure conforme sua necessidade, inclusive
	recebendo parmetros do template objeto_pesquisa
*/
$sql = "SELECT usuario.*, departamento.nome_departamento "
     . "FROM usuario, departamento "
     . "WHERE usuario.departamento_id=departamento.departamento_id "
     . "ORDER BY usuario.nome_usuario";
$rs = new query($conn, $sql);

/*
	incio da iterao
*/
while ($rs->getrow()) {
	$pdf->Cell(70,4,$rs->field("nome_usuario"),"T",0,"L");
	$pdf->Cell(35,4,$rs->field("nome_departamento"),"T",0,"L");
	$pdf->MultiCell(0,4,$rs->field("descricao"),"T");
}

/*
	encerra a conexo com o banco de dados
*/
$conn->close();

/*
	comandos HEADER que disponibiliza o documento
	para download
*/
header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
header("Cache-Control: no-store, no-cache, must-revalidate"); // HTTP/1.1
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: public"); // HTTP/1.0

/*
	cria o documento,
	altere o nome do arquivo conforme sua necessidade
*/
$pdf->Output("relatorio.pdf",true);
?>