<?
/*
	Modelo de pgina que apresenta um formulrio
	para incluso/alterao de registros
*/
include("../inc/common.php");

/*
	verificao do nvel do usurio
*/
verificaPermissao("10,1");

/*
	estabelece conexo com o banco de dados
*/
$conn = new db();
$conn->open();

/*
	tratamento de campos, caso seja edio.
	configure conforme suas necessidades
*/
$id = getParam("id"); // captura a varivel que veio de objeto_lista
if (strlen($id)>0) { // edio
	$sql = "SELECT * FROM usuario WHERE usuario_id=" . $id;
	$rs = new query($conn, $sql);
	if ($rs->getrow()) {
		$bd_usuario_id            = $rs->field("usuario_id");
		$bd_data_cadastro         = stod($rs->field("data_cadastro"));
		$bd_nome_usuario          = $rs->field("nome_usuario");
		$bd_senha                 = $rs->field("senha");
		$bd_nivel_acesso          = $rs->field("nivel_acesso");
		$bd_nome_real             = $rs->field("nome_real");
		$bd_departamento_id       = $rs->field("departamento_id");
		$bd_email                 = $rs->field("email");
		$bd_descricao             = $rs->field("descricao");
		$bd_ativo                 = $rs->field("ativo");
	}
} else { // incluso
	$bd_data_cadastro           = date("d/m/Y");
	$bd_nivel_acesso            = 1;
}

// definio da expresso SQL para a funo listbox
$sqlDepartamento = "SELECT departamento_id as id, nome_departamento as val FROM departamento ORDER BY nome_departamento";

// definio do lookup
$dep = new Lookup();
$dep->setTitle("Departamentos");
$dep->setNomeCampoForm("f_departamento_id_teste");
$dep->setNomeTabela("departamento");
$dep->setNomeCampoChave("departamento_id");
$dep->setNomeCampoExibicao("nome_departamento");
$dep->setNomeCampoAuxiliar("nome_departamento"); // opcional
$dep->setValorCampoForm($bd_departamento_id);

// definio da lista para o campo RadioField
$lista_nivel = array("1,Operador","2,Manuteno","3,Administrador");
?>
<html>
<head>
	<title>objeto-edicao</title>
	<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
	<link rel="stylesheet" type="text/css" href="<?=CSS_CONTENT?>">
	<?=carregaJS("popcalendar,lookup,focus,textcounter,editor");?>
	<script language='JavaScript'>
	/*
		funo que chama a rotina de salvamento,
		altere somente o nome da pgina
	*/
	function salvar() {
		parent.content.document.frm.target = "controle";
		parent.content.document.frm.action = "../content/objeto_salvar.php";
		parent.content.document.frm.submit();
	}
	
	/*
		exemplo de funo que chama script no frame controle para complementar o
		processamento dos campos no formulrio. normalmente chamado pelo onChange dos
		campos do formulrio.
	*/
	function atualizaCampo(frm) {
		indice = frm.f_campo.selectedIndex;
		localizacao = "objeto_atualizar.php?pesq=" + frm.f_campo.options[indice].value;
		parent.controle.location = localizacao;
	}
	
	/*
		funo que define o foco inicial do formulrio,
		altere conforme o campo do formulrio
	*/
	function inicializa() {
		parent.content.document.frm.f_nome_usuario.focus();
	}
	</script>

</head>
<body class="contentBODY" onload="inicializa()">

<?
pageTitle("Objeto","Edio");

/*
	botes de aes,
	configure conforme suas necessidades
*/
$retorno = $_SERVER['QUERY_STRING'];

$button = new Button;
$button->addItem(" Salvar ","javascript:salvar()","content");
$button->addItem(" Fechar ","../content/objeto_lista.php?$retorno","content");
echo $button->writeHTML();

/*
	Controle de abas,
	true, se for a aba da pgina atual,
	false, se for qualquer outra aba,
	configure conforme o exemplo abaixo
*/
$abas = new Abas();
$abas->addItem("Geral",true);
if ($id != "") { // se for incluso, esconde as outras abas
	$abas->addItem("Associao",false,  "../content/objeto_associacao.php?id=$id");
	$abas->addItem("Ordenao" ,false,  "../content/objeto_ordenacao.php?id=$id");	
	$abas->addItem("Detalhe"   ,false,  "../content/objeto_consulta.php?id=$id");
	$abas->addItem("Lista 1:N" ,false,  "../content/objeto_lista_1n.php?id=$id",3);
}
echo $abas->writeHTML();

echo "<br>";

/*
	Formulrio
*/
$form = new Form("frm", "../content/objeto_salvar.php", "POST", "controle", "100%");
$form->setLabelWidth("20%");
$form->setDataWidth("80%");

$form->addHidden("rodou","s"); // varivel de controle
$form->addHidden("f_id",              $bd_usuario_id); // chave primria
$form->addHidden("pagina",            getParam("pagina")); // nmero da pgina que chamou

$form->addField("Data de cadastro: ", dateField("f_data_cadastro",$bd_data_cadastro,"readonly"));
$form->addField("Nome do usurio: ",  textField("f_nome_usuario",$bd_nome_usuario,20,20));
$form->addField("Senha: ",            passwordField("f_senha",$bd_senha,20,20) . help("Ttulo da ajuda","Texto de ajuda Texto de ajuda Texto de ajuda Texto de ajuda Texto de ajuda Texto de ajuda"));
$form->addField("Nvel de acesso: ",  radioField($lista_nivel,"f_nivel_acesso",$bd_nivel_acesso));
$form->addField("Nome real: ",        textField("f_nome_real",$bd_nome_real,50,50));
$form->addBreak("<b>Exemplo de quebra de formulrio</b>");
$form->addField("Departamento: ",     listboxField($sqlDepartamento, "f_departamento_id",$bd_departamento_id,"",""));
$form->addField("Departamento 2: ",   $dep->writeHTML());
$form->addField("Departamento 3: ",   scrollBlock(multipleCheckboxField("f_departamento_id_teste2", $bd_departamento_id, "departamento", "departamento_id", "nome_departamento"),"60px","150px"));
$form->addField("E-mail: ",           textField("f_email",$bd_email,50,100));
$form->addField("Descrio: ",        textAreaField("f_descricao",$bd_descricao,3,50,200));
$form->addField("Ativo: ",            checkboxField("f_ativo",1,$bd_ativo==1));
$form->addField("Documento: ",        fileField("f_arquivo","imagem.jpg",30));
echo $form->writeHTML();
?>
</body>
</html>
<?
/*
	encerra a conexo com o banco de dados
*/
$conn->close();
?>
