<?
/*
	Est pgina exibe um modelo de associao de registros,
	onde um ou mais registros so selecionados e logo aps
	salvos.
*/
include("../inc/common.php");

/*
	verificao do nvel do usurio,
	altere conforme sua necessidade,
	quanto maior o valor, maior a restrio
*/
verificaPermissao("10,1");

/*
	liga/desliga utilizao de filtro
*/
$usaFiltro = true;

/*
	recupera chave, se existir
*/
$id = getParam("id");

/*
	conexo com o banco de dados,
	altere somente se a conexo for diferente do default
*/
$conn = new db();
$conn->open();

/*
	lista destino,
	configure conforme sua necessidade
*/
$sql = "SELECT sistema_usuario.sistema_id as id, sistema.nome_sistema as val " .
       "FROM sistema_usuario, sistema " .
       "WHERE sistema_usuario.sistema_id=sistema.sistema_id " .
       "AND sistema_usuario.usuario_id=$id " .
       "ORDER BY sistema.nome_sistema";
$rsDestino = new query($conn, $sql);
while ($rsDestino->getrow()) $aLista[] = $rsDestino->field("id");
$lista=is_array($aLista)?implode(",",$aLista):"0";
$rsDestino->free();
$rsDestino = new query($conn, $sql);


/*
	lista origem,
	configure conforme sua necessidade
*/
$sql = "SELECT sistema_id as id, nome_sistema as val " .
       "FROM sistema ".
		 "WHERE sistema_id NOT IN ($lista) ".
		 "ORDER BY nome_sistema";
$rsOrigem = new query($conn, $sql);
?>
<html>
<head>
	<title>objeto-associacao</title>
	<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
	<link rel="stylesheet" type="text/css" href="<?=CSS_CONTENT?>">
	<script language="JavaScript" src="../inc/js/moveselect.js"></script>
	<? if ($usaFiltro) { ?>
	<script language="JavaScript" src="../inc/js/filterlist.js"></script>
	<? } ?>
	<script language="JavaScript">
	/*
		funo que chama a rotina de processamento,
		altere somente o nome da pgina
	*/
	function salvar() {
		selecionaObjetosAssociados();
		parent.content.document.frm.target = "controle";
		parent.content.document.frm.action = "../content/objeto_associar.php";
		parent.content.document.frm.submit();
	}
	function inicializa() {
		<? if ($usaFiltro) { ?>
		parent.content.document.frm.searchOrigem.focus();
		<? } ?>
	}
	</script>
</head>
<body class="contentBODY" onLoad="inicializa()">

<?
pageTitle("Objeto","Associao");

// botes de aes,
// configure conforme sua necessidade
$button = new Button;
$button->addItem(" Salvar ","javascript:salvar()","content");
$button->addItem(" Fechar ","../content/objeto_lista.php","content");
echo $button->writeHTML();

// Controle de abas,
// true, se for a aba da pgina atual,
// false, se for qualquer outra aba,
// configure conforme o exemplo abaixo
$abas = new Abas();
$abas->addItem("Geral",false,"../content/objeto_edicao.php?id=$id");
$abas->addItem("Associao",true);
$abas->addItem("Ordenao",false,"../content/objeto_ordenacao.php?id=$id");
$abas->addItem("Detalhe",false,"../content/objeto_consulta.php?id=$id");
$abas->addItem("Lista 1:N",false,"../content/objeto_lista_1n.php?id=$id",3);
echo $abas->writeHTML();
?>
<form name="frm" method="post">
<!-- varivel de controle -->
<input type="hidden" name="rodou" value="s">
<!-- chave primria -->
<input type="hidden" name="f_id" value="">
<?
// montagem da lista de origem
if ($usaFiltro) {
	$montaOrigem  = "<input type=\"text\" name=\"searchOrigem\" size=\"30\" style=\"WIDTH: 100%\" onKeyUp=\"javascript:filterOrigem.set(this.value)\"><br>";
} else {
	$montaOrigem = "";
}
$montaOrigem .= "<select id=\"f_origem\" name=\"f_origem\" multiple size=\"16\" style=\"WIDTH: 100%\" valign=\"top\">";
while ($rsOrigem->getrow()) {
	$montaOrigem .= "<option value='".$rsOrigem->field("id")."'>".$rsOrigem->field("val")."</option>";
}
$montaOrigem .= "</select>";

// montagem da lista de destino
if ($usaFiltro) {
	$montaDestino  = "<input type=\"text\" name=\"searchDestino\" size=\"30\" style=\"WIDTH: 100%\" onKeyUp=\"javascript:filterDestino.set(this.value)\"><br>";
} else {
	$montaDestino = "";
}
$montaDestino .= "<select name=\"f_destino[]\" id=\"f_destino\" multiple size=\"16\" style=\"WIDTH: 100%;\">";
while ($rsDestino->getrow()) {
	$montaDestino .= "<option value='".$rsDestino->field("id")."'>".$rsDestino->field("val")."</option>";
}
$montaDestino .= "</select>";

// monta botes
if ($usaFiltro) {
	$js = "filterDestino.init();filterOrigem.init();";
} 
$montaBotoes  = "<input type=\"button\" onClick=\"move(parent.content.document.frm.f_origem,parent.content.document.frm.f_destino);$js\" value=\" >> \">";
$montaBotoes .= "<br><br>";
$montaBotoes .= "<input type=\"button\" onClick=\"move(parent.content.document.frm.f_destino,parent.content.document.frm.f_origem);$js\" value=\" << \">";


// layout
$table = new Table("","100%",3);
// cabealho
$table->addColumnHeader("Objetos Disponveis",false,"47%","C");
$table->addColumnHeader("",false,"6%","C");
$table->addColumnHeader("Objetos Selecionados",false,"47%","C");
$table->addRow();
// caixas de seleo
$table->addData($montaOrigem, "C");
$table->addData($montaBotoes, "C");
$table->addData($montaDestino, "C");
$table->addRow();
echo $table->writeHTML();
echo help("Associao","Utilize a tecla CTRL pressionada para efetuar seleo mltipla de registros.");
?>
<!-- layout do formulrio -->
<? if ($usaFiltro) { ?>
<script>
var filterOrigem = new filterlist(document.frm.f_origem);
var filterDestino = new filterlist(document.frm.f_destino);
</script>
<? } ?>
</form>


</body>
</html>
<?
$conn->close();
?>