<?
// +----------------------------------------------------------------------+
// | BoletoPhp - Verso Beta                                              |
// +----------------------------------------------------------------------+
// | Este arquivo est disponvel sob a Licena GPL disponvel pela Web   |
// | em http://pt.wikipedia.org/wiki/GNU_General_Public_License           |
// | Voc deve ter recebido uma cpia da GNU Public License junto com     |
// | esse pacote; se no, escreva para:                                   |
// |                                                                      |
// | Free Software Foundation, Inc.                                       |
// | 59 Temple Place - Suite 330                                          |
// | Boston, MA 02111-1307, USA.                                          |
// +----------------------------------------------------------------------+

// +----------------------------------------------------------------------+
// | Originado do Projeto BBBoletoFree que tiveram colaboraes de Daniel |
// | William Schultz e Leandro Maniezo que por sua vez foi derivado do	  |
// | PHPBoleto de Joo Prado Maia e Pablo Martins F. Costa				  |
// | 																	  |
// | Se vc quer colaborar, nos ajude a desenvolver p/ os demais bancos :-)|
// | Acesse o site do Projeto BoletoPhp: www.boletophp.com.br             |
// +----------------------------------------------------------------------+

// +--------------------------------------------------------------------------------------------------------+
// | Equipe Coordenao Projeto BoletoPhp: <boletophp@boletophp.com.br>              						|
// | Desenvolvimento Boleto Banco do Brasil: Daniel William Schultz / Leandro Maniezo / Rogrio Dias Pereira|
// +--------------------------------------------------------------------------------------------------------+
// ALTER TABLE `central_controledesites`.`contasReceber` ADD `nosso_numero` VARCHAR(50);
include("../inc/common.php");
$conn = new db();
$conn->open();

$sql =   "SELECT d.dominio, "
   	 	 . "	 	   p.plano, "
			 . "		 	 cr.dt_vencimento, cr.valor AS cr_valor, "
			 . "		 	 c.ativo, c.cod_contrato, "
			 . "		 	 cl.nome, "
			 . "		 	 cr.nosso_numero AS cr_nosso_numero, "
			 . " 			 e.*, e.endereco AS cli_endereco, "
			 . "			 b.* "
   	 	 . "FROM dominio d, contrato c, plano p, contasReceber cr, cliente cl, boleto b, endereco e "
     	 . "WHERE d.cod_dominio = c.cod_dominio " 
     	 . " AND c.cod_plano = p.cod_plano " 
     	 . " AND c.cod_contrato = cr.cod_contrato " 
  	 	 . " AND c.cod_cliente = cl.cod_cliente "
  		 . " AND c.cod_boleto = b.cod_boleto "
			 . " AND cl.cod_cliente = e.cod_cliente "
			 . " AND c.cod_contrato = ".getParam("id")
  	 	 . " AND cr.pago = 0 ";

$rs = new query($conn, $sql);
$rs->getrow(); //print_r($rs);

$valor_cobrado = substr($rs->field("cr_valor"),3); // Valor - REGRA: Tanto faz smbolo da casa decimal com "." ou ","
// nosso_numero

$data_venc = stod($rs->field("dt_vencimento"));

if ($rs->field("dt_vencimento") < date("Y-m-d"))
	  $data_venc = date("d/m/Y");

// ------------------------- DADOS DINMICOS DO SEU CLIENTE PARA A GERAO DO BOLETO (FIXO OU VIA GET) -------------------- //
// Os valores abaixo podem ser colocados manualmente ou ajustados p/ formulrio c/ POST, GET ou de BD (MySql,Postgre,etc)	//
				 
// DADOS DO BOLETO PARA O SEU CLIENTE
$dias_de_prazo_para_pagamento = 5;
$taxa_boleto = $rs->field("taxa_boleto");	//						 		 						 								 							 			 **OK**
// se estiver vencido, coloca uma nova data de vencimento
// seno, coloca a que vem da base de dados
$data_venc = date($data_venc, time() + ($dias_de_prazo_para_pagamento * 86400));  // Prazo de X dias OU informe data: "13/04/2006"; 
$valor_cobrado = str_replace(",", ".",$valor_cobrado);
$valor_boleto = number_format(($valor_cobrado + $taxa_boleto), 2, ',', ''); //echo $valor_cobrado;

$nosso_numero = substr($rs->field("cr_nosso_numero"), 7);
//$len_nosso_numero = strlen($nosso_numero);
//$zeros = 8 - $len_nosso_numero;
//for ($i = 1; $i <= $zeros; $i++)
	//	 $nosso_numero = "0".$nosso_numero;

$dadosboleto["nosso_numero"] = $nosso_numero;
$dadosboleto["numero_documento"] = $nosso_numero;	// Num do pedido ou nosso numero, s aparece no layout
$dadosboleto["data_vencimento"] = $data_venc; // Data de Vencimento do Boleto
$dadosboleto["data_documento"] = date("d/m/Y"); // Data de emisso do Boleto 		 				 **OK**
$dadosboleto["data_processamento"] = ""; // Data de processamento do boleto (opcional)	 **OK**
// Valor do Boleto, com vrgula, sempre com duas casas depois da virgula
$dadosboleto["valor_boleto"] = $valor_boleto; 	//echo ($valor_cobrado + $taxa_boleto);

// DADOS DO SEU CLIENTE
$dadosboleto["sacado"] = $rs->field("nome"); //echo $rs->field("endereco");//	 			 					 												 **OK**
$dadosboleto["endereco1"] = "Rua ".$rs->field("cli_endereco")." ".$rs->field("numero")." ".$rs->field("complemento")." ".$rs->field("bairro");
$dadosboleto["endereco2"] = $rs->field("cidade")." - ".$rs->field("estado")." - CEP: ".$rs->field("cep");

// INFORMACOES PARA O CLIENTE
$dadosboleto["instrucoes"] = $rs->field("instrucoes");   // **OK**
$dadosboleto["instrucoes1"] = $rs->field("instrucoes1"); // **OK**
$dadosboleto["instrucoes2"] = $rs->field("instrucoes2"); // **OK**
$dadosboleto["instrucoes3"] = $rs->field("instrucoes3"); // **OK**
$dadosboleto["instrucoes4"] = $rs->field("instrucoes4"); // **OK**

// DADOS OPCIONAIS DE ACORDO COM O BANCO OU CLIENTE
$dadosboleto["quantidade"] = $rs->field("quantidade"); //			 					 					 				 **OK**
$dadosboleto["valor_unitario"] = $rs->field("valor_unitario"); //														 ?
$dadosboleto["aceite"] = "Sim";		//		 					 					 				 **OK**
$dadosboleto["uso_banco"] = ""; 	//		 					 					 				 **OK**
$dadosboleto["especie"] = $rs->field("especie");     	// 					 					 				 **OK**
$dadosboleto["especie_doc"] = "DM"; // 															 **OK**


// ---------------------- DADOS FIXOS DE CONFIGURAO DO SEU BOLETO --------------- //


// DADOS DA SUA CONTA - BANCO DO BRASIL 
$dadosboleto["agencia"] = $rs->field("agencia"); // Num da agencia, sem digito   -  **OK**
$dadosboleto["conta"] = $rs->field("conta"); 	// Num da conta, sem digito    -   **OK**

// DADOS PERSONALIZADOS - BANCO DO BRASIL
$dadosboleto["convenio"] = $rs->field("convenio");  // Num do convnio - REGRA: 6 ou 7 dgitos    **??OK??**
$dadosboleto["contrato"] = $rs->field("contrato"); // Num do seu contrato
$dadosboleto["carteira"] = $rs->field("carteira");  // Cdigo da Carteira 18 - 17 ou 11      **OK**
$dadosboleto["variacao_carteira"] = $rs->field("variacao_carteira");  // Variao da Carteira, com trao (opcional)

// TIPO DO BOLETO
$dadosboleto["formatacao_convenio"] = $rs->field("formatacao_convenio"); // REGRA: Informe 7 se for Convnio com 7 dgitos ou 6 se for Convnio com 6 dgitos
$dadosboleto["formatacao_nosso_numero"] = $rs->field("formatacao_nosso_numero"); // REGRA: Se for Convnio com 6 dgitos, informe 1 se for NossoNmero de at 5 dgitos ou 2 para opo de at 17 dgitos

/*
#################################################
DESENVOLVIDO PARA CARTEIRA 18

- Carteira 18 com Convenio de 7 digitos
  Nosso nmero: pode ser at 10 dgitos

- Carteira 18 com Convenio de 6 digitos
  Nosso nmero:
  de 1 a 99999 para opo de at 5 dgitos
  de 1 a 99999999999999999 para opo de at 17 dgitos

#################################################
*/


// SEUS DADOS
$dadosboleto["identificacao"] = "";	//					 			 	 								 **OK**
$dadosboleto["cpf_cnpj"] = "";	//																			 **OK**
$dadosboleto["endereco"] = "";	//																			 **OK**
$dadosboleto["cidade_uf"] = "";	//																			 **OK**
$dadosboleto["cedente"] = $rs->field("cedente"); //					 **OK**

// NO ALTERAR!
include("include/funcoes_bb.php");// 
include("include/layout_bb.php"); // 00190.00009 01372.429009 00015.235187 8 34220000003500
																	// 001 - banco
																	// 9	 - moeda
																	// 0000 - livre
																	// 9 		-	DV
																	// nosso_num = 13724290000015235-4
?>
