<?
/*
	Modelo de pgina que apresenta uma lista de registros
*/
include("../inc/common.php");


/*
	verificao do nvel do usurio, altere conforme sua necessidade, quanto maior o valor,
	maior a restrio
*/
verificaPermissaoPagina("11,10,1");


/*
	conexo com o banco de dados, altere somente se a conexo for diferente do default
*/
$conn = new db();
$conn->open();


/*
	determina a pgina a ser exibida, no precisa alterar
*/
$pg = getParam("pagina");
if ($pg == "") $pg = 1;


/*
	Limpa ordenao e filtro, no deve ser alterado
*/
if (getParam("clear")==1) {
	setSession("sOrder","");
	setSession("where","");
	setSession("pagina_atual","");
}

/*
	Salva o status da pgina atual, no deve ser alterado
*/
if ($_SERVER['PHP_SELF'] != getSession("pagina_atual")) {
	$mesma_pagina = false;
	setSession("pagina_atual",$_SERVER['PHP_SELF']);
} else {
	$mesma_pagina = true;
}


/*
	construo da ordenao
*/
$iSort = getParam("Sorting");
$iSorted = getParam("Sorted");
if ((!$iSort)&&(!$mesma_pagina)) {
	$form_sorting = "";
	$iSort = 2; // configure a ordenao inicial da lista de acordo com as colunas da tabela
	$iSorted = ""; // se a ordenao estiver DESCENDENTE, repita o mesmo valor abaixo
}
if ($iSort) {
	if ($iSort == $iSorted) {
		$form_sorting = "";
		$sDirection = " DESC";
		$sSortParams = "Sorting=" . $iSort . "&Sorted=" . $iSort . "&";
	} else {
		$form_sorting = $iSort;
		$sDirection = " ASC";
		$sSortParams = "Sorting=" . $iSort . "&Sorted=" . "&";
	}
	/*
		coloque aqui a definio das ordenaes das colunas de acordo com as colunas da tabela
	*/
	if ($iSort == 2) setSession("sOrder"," order by fornecedor.nome" . $sDirection);
	if ($iSort == 3) setSession("sOrder"," order by fornecedor.tipo_fornecedor" . $sDirection);
}



if (getParam("rodou")=="s") { // se ocorreu pesquisa...
	$onde = "";
	/*
		construa a string WHERE conforme o exemplo abaixo
	*/
	if (getParam("pesq_nome") != "")    $onde .= "AND fornecedor.nome LIKE '%" . getParam("pesq_nome") . "%'";
    if (getParam("pesq_tipo_fornecedor") != "" and getParam("pesq_tipo_fornecedor") != " ")    $onde .= "AND fornecedor.tipo_fornecedor LIKE '" .  getParam("pesq_tipo_fornecedor")."'" ;

	
	setSession("where",$onde);
}

/*
	flag pra informar se o filtro est ou no ativo
*/
if (strlen(getSession("where"))>0) {
	$filtrado = FILTRO_ATIVO;
} else {
	$filtrado = "";
}


/*
	expresso SQL que define a lista, construa livremente observando a concatenao com as
	sessions WHERE e sOrder, conforme exemplo abaixo
*/
$sql = "SELECT fornecedor.codigo, fornecedor.nome, fornecedor.tipo_fornecedor FROM fornecedor "
			."WHERE fornecedor.codigo > 0 "
			. getSession("where") . getSession("sOrder");

/*
	criao do recordset, altere somente o ltimo parmetro que	corresponde a quantidade de
	registros por pgina
*/
$rs = new query($conn, $sql, $pg, 50);
//$rs = new query($conn, $sql);
?>
<html>
<head>
	<title>fornecedor-lista</title>
	<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
	<link rel="stylesheet" type="text/css" href="<?=CSS_CONTENT?>">
	<script language="javascript" src="../inc/js/checkall.js"></script>

	<script language="JavaScript">
	/*
		funo que chama a rotina de excluso de registros, altere somente o nome da pgina
		a ser chamada
	*/
	function excluir() {
		if (confirm('ATENO!! Voc deseja realmente excluir os fornecedores selecionados?')) {
			parent.content.document.frm.target = "controle";
			parent.content.document.frm.action = "../admin/fornecedor_excluir.php";
			parent.content.document.frm.submit();
		}
	}

	/*
		funo de exemplo para chamar um processamento qualquer
	*/
	function processar() {
		if (confirm('Processar registros selecionados?')) {
			parent.content.document.frm.target = "controle";
			parent.content.document.frm.action = "../admin/fornecedor_processar.php";
			parent.content.document.frm.submit();
  }
 }
	</script>
</head>
<body class="contentBODY">

<?
pageTitle("Fornecedor","Lista");

/*
	botes de aes
*/
$button = new Button;

/*
	botes de navegao da lista, no deve ser alterada
*/
$pg_ant = $pg-1;
$pg_prox = $pg+1;
if ($pg>1)                 $button->addItem(LISTA_ANTERIOR,$_SERVER['PHP_SELF']."?pagina=$pg_ant" ,"content");
if ($pg<$rs->totalpages()) $button->addItem(LISTA_PROXIMO ,$_SERVER['PHP_SELF']."?pagina=$pg_prox","content");

/*
	botes de aes da lista, altere conforme suas necessidades
*/
$button->addItem("Novo Fornecedor","../admin/fornecedornovo_cadastro.php","content");
$button->addItem("Pesquisa",   "../admin/fornecedor_pesquisa.php","content");
$button->addItem("Excluir",    "javascript:excluir()","content");
echo $button->writeHTML();
?>

<!-- Lista -->
<div align="center">
<form name="frm" method="post">
<?
/*
	inicializao da tabela
*/
$table = new Table("","100%",6); // Ttulo, Largura, Quantidade de colunas

/*
	Configurao das colunas da tabela
*/
$table->addColumnHeader("<input type=\"checkbox\" name=\"checkall\"onclick=\"CheckAll()\">"); // Coluna com checkbox
$table->addColumnHeader("Fornecedor",true,"45%", "L"); // Ttulo, Ordenar?, Largura, Alinhamento
$table->addColumnHeader("Tipo",true,"45%", "L"); // Ttulo, Ordenar?, Largura, Alinhamento
//$table->addColumnHeader("Eventos",true,"10%", "C");
$table->addRow(); // adiciona linha (TR)

while ($rs->getrow()) {
	$id = $rs->field("codigo"); // captura a chave primria do recordset

	$table->addData("<input type=\"checkbox\" name=\"sel[]\" value=\"$id\">");
	$table->addData(addLink($rs->field("nome"),"../admin/fornecedornovo_cadastro.php?id=$id&pagina=$pg"));
	$table->addData($rs->field("tipo_fornecedor"));
	//$table->addData("$$", "C");
	//$table->addData(addLink("$$","../admin/adm_dominio_lista.php?pesq_cliente=$id&rodou=s"), "C");
	$table->addRow();
}

echo "<div class='DataFONT' align='right'><b>$filtrado</b></div>";

/*
	Desenha a tabela
*/
if ($rs->numrows()>0) {
	echo $table->writeHTML();
	echo "<div class='DataFONT'>Pgina ".$pg." de ".$rs->totalpages()."</div>";
} else {
	echo "<div class='DataFONT'>Nenhum registro encontrado!</div>";
}
?>
</form>
</div>

</body>
</html>
<?
/*
	fecha a conexo com o banco de dados, no deve ser alterado
*/
$conn->close();
?>
