<?
include("../inc/common.php");

verificaPermissaoPagina("11,10,5");

$conn = new db();
$conn->open();

/*
O sistema manda um aviso informando que o boleto vai vencer daqui a 5 dias.

Ao chegar na data do vencimento o sistema avisa novamente que HOJE est vencendo a fatura.
 
Aps a data do vencimento ( todos os dias ) o sistema envia um aviso informando 
que o boleto est atrazado e que a conta poder ser bloqueada. 
Este aviso deve persistir por 7 dias.
O sbado e domingo deve ser contado dentro dos 7 mas o sistema no deve enviar.
*/

$sql = "SELECT dominio, dt_vencimento, "
		 	 .		 " cliente.nome, cliente.email "
		 	 . "FROM dominio, contrato, contasReceber, cliente "
       . "WHERE dominio.cod_dominio = contrato.cod_dominio " 
       . "AND contrato.cod_contrato = contasReceber.cod_contrato " 
			 . "AND contrato.cod_cliente = cliente.cod_cliente "
			 . "AND contasReceber.pago = 0 "
			 . "AND contasReceber.dt_vencimento < '".dtos(somadata(date("d/m/Y"),+5))."'"; //echo $sql;

$rs = new query($conn, $sql);

while ($rs->getrow()) {
	$id = $rs->field("cod_contrato"); // captura a chave primria do recordset
	$cod_conta = $rs->field("cod_conta");
	$nosso_numero = $rs->field("nosso_numero");echo "<br>"; echo "<br>";

	// manda email de confirmao de pagamento
	$dominio = $rs->field("dominio");
	$subject = "central.modelosdesites";
	$email = $rs->field("email");
	$vencimentoAtual = stod($rs->field("dt_vencimento"));

	// 5 dias antes
	if ($rs->field("dt_vencimento") > date("Y-m-d")) {
    	$message = "Enviamos esta mensagem para lembrar que o pagamento relativo ao domnio $dominio deve ser feito at $vencimentoAtual.";
    	$message .= "<br>Mantenha o pagamento em dia e evite o bloqueio do seu domnio."; //echo $message;
			geraEmailAviso($subject, $email, $message);
	}
	
	// no dia
	if ($rs->field("dt_vencimento") == date("Y-m-d")) {
    	$message = "Enviamos esta mensagem para lembrar que o pagamento relativo ao domnio $dominio deve ser feito hoje.";
    	$message .= "<br>Mantenha o pagamento em dia e evite o bloqueio do seu domnio."; //echo $message;
			geraEmailAviso($subject, $email, $message);
	}
	
	// conta atrazada at 7 dias
	if ($rs->field("dt_vencimento") < date("Y-m-d") && $rs->field("dt_vencimento") > dtos(somadata(date("d/m/Y"), -7))) {
    	$message = "Enviamos esta mensagem para lembrar que o pagamento relativo ao domnio $dominio venceu em $vencimentoAtual .";
    	$message .= "<br>Mantenha o pagamento em dia e evite o bloqueio do seu domnio."; //echo $message;
			geraEmailAviso($subject, $email, $message);
	}
}

// boletos avulsos
$sql = "SELECT * "
		 	 . "FROM contasReceber "
       . "WHERE contasReceber.pago = 0 "
			 . "AND contasReceber.dt_vencimento < '".dtos(somadata(date("d/m/Y"),+5))."'"; //echo $sql;

$rs = new query($conn, $sql);

while ($rs->getrow()) {
	$id = $rs->field("cod_contrato"); // captura a chave primria do recordset
	$cod_conta = $rs->field("cod_conta");
	$nosso_numero = $rs->field("nosso_numero");echo "<br>"; echo "<br>";

	// manda email de confirmao de pagamento
	$dominio = $rs->field("dominio");
	$subject = "central.modelosdesites";
	$email = $rs->field("email");
	$vencimentoAtual = stod($rs->field("dt_vencimento"));

	// 5 dias antes
	if ($rs->field("dt_vencimento") > date("Y-m-d")) {
    	$message = "Enviamos esta mensagem para lembrar que o pagamento relativo ao boleto $nosso_numero deve ser feito at $vencimentoAtual.";
    	$message .= "<br>Mantenha o pagamento em dia e evite o bloqueio."; //echo $message;
			geraEmailAviso($subject, $email, $message);
	}

	// no dia
	if ($rs->field("dt_vencimento") == date("Y-m-d")) {
    	$message = "Enviamos esta mensagem para lembrar que o pagamento relativo ao boleto $nosso_numero deve ser feito hoje.";
    	$message .= "<br>Mantenha o pagamento em dia e evite o bloqueio do seu domnio."; //echo $message;
			geraEmailAviso($subject, $email, $message);
	}

	// conta atrazada at 7 dias
	if ($rs->field("dt_vencimento") < date("Y-m-d") && $rs->field("dt_vencimento") > dtos(somadata(date("d/m/Y"), -7))) {
    	$message = "Enviamos esta mensagem para lembrar que o pagamento relativo ao boleto $nosso_numero venceu em $vencimentoAtual .";
    	$message .= "<br>Mantenha o pagamento em dia e evite o bloqueio do seu domnio."; //echo $message;
			geraEmailAviso($subject, $email, $message);
	}
}
?>
	<script language="JavaScript">
			alert("Emails enviados com sucesso!");
			self.location.href='javascript:window.history.go(-1)';
	</script>
<?
$conn->close();
?>
