<?
/*
	Modelo de pgina que apresenta um formulrio
	para incluso/alterao de registros
*/
include("../inc/common.php");

/*
	verificao do nvel do usurio
*/
verificaPermissaoPagina("11,10,5");

/*
	estabelece conexo com o banco de dados
*/
$conn = new db();
$conn->open();

/*
	tratamento de campos, caso seja edio.
	configure conforme suas necessidades
*/
$id = getParam("id"); // captura a varivel que veio de objeto_lista
if (strlen($id)>0) { // edio
	$sql = "SELECT * FROM email WHERE cod_email=" . $id;
	$rs = new query($conn, $sql);
	if ($rs->getrow()) {
		$bd_cod_email             = $rs->field("cod_email");
		$bd_titulo                = $rs->field("titulo");
		$bd_texto                 = $rs->field("texto");
	}
}

// definio da expresso SQL para a funo listbox
$sqlDepartamento = "SELECT departamento_id as id, nome_departamento as val FROM departamento ORDER BY nome_departamento";

// definio do lookup
$dep = new Lookup();
$dep->setTitle("Departamentos");
$dep->setNomeCampoForm("f_departamento_id_teste");
$dep->setNomeTabela("departamento");
$dep->setNomeCampoChave("departamento_id");
$dep->setNomeCampoExibicao("nome_departamento");
$dep->setNomeCampoAuxiliar("nome_departamento"); // opcional
$dep->setValorCampoForm($bd_departamento_id);

// definio da lista para o campo RadioField
$lista_nivel = array("1,Operador","2,Manuteno","3,Administrador");
?>
<html>
<head>
	<title>email-edicao</title>
	<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
	<link rel="stylesheet" type="text/css" href="<?=CSS_CONTENT?>">
	<?=carregaJS("popcalendar,lookup,focus,textcounter,editor");?>
	<script language='JavaScript'>
	/*
		funo que chama a rotina de salvamento,
		altere somente o nome da pgina
	*/
	function salvar() {
		parent.content.document.frm.target = "controle";
		parent.content.document.frm.action = "../admin/email_salvar.php";
		parent.content.document.frm.submit();
	}
	
	/*
		exemplo de funo que chama script no frame controle para complementar o
		processamento dos campos no formulrio. normalmente chamado pelo onChange dos
		campos do formulrio.
	*/
	function atualizaCampo(frm) {
		indice = frm.f_campo.selectedIndex;
		localizacao = "email_atualizar.php?pesq=" + frm.f_campo.options[indice].value;
		parent.controle.location = localizacao;
	}
	
	/*
		funo que define o foco inicial do formulrio,
		altere conforme o campo do formulrio
	*/
	function inicializa() {
		parent.content.document.frm.f_titulo.focus();
	}
	</script>

</head>
<body class="contentBODY" onload="inicializa()">

<?
pageTitle("Email","Edio");

/*
	botes de aes,
	configure conforme suas necessidades
*/
$retorno = $_SERVER['QUERY_STRING'];

$button = new Button;
$button->addItem(" Salvar ","javascript:salvar()","content");
$button->addItem(" Fechar ","../admin/email_lista.php?$retorno","content");
echo $button->writeHTML();

/*
	Controle de abas,
	true, se for a aba da pgina atual,
	false, se for qualquer outra aba,
	configure conforme o exemplo abaixo
*/
$abas = new Abas();
$abas->addItem("Geral",true);
echo $abas->writeHTML();

echo "<br>";

/*
	Formulrio
*/
$form = new Form("frm", "../admin/email_salvar.php", "POST", "controle", "100%");
$form->setLabelWidth("20%");
$form->setDataWidth("80%");

$form->addHidden("rodou","s"); // varivel de controle
$form->addHidden("f_id",              $bd_cod_email); // chave primria
$form->addHidden("pagina",            getParam("pagina")); // nmero da pgina que chamou

$form->addField("Titulo: ",  textField("f_titulo",$bd_titulo,30,50));
$form->addField("Email: ",            textAreaFieldEditor("f_texto",$bd_texto,3,50));
echo $form->writeHTML();
?>
</body>
</html>
<?
/*
	encerra a conexo com o banco de dados
*/
$conn->close();
?>
