<?
/*
	Transao de incluso/alterao de registros
*/
include("../inc/common.php");

/*
	verificao do nvel do usurio
*/
verificaPermissaoPagina("11,10,1");

/*
	conexo com o banco de dados
*/
$conn = new db();
$conn->open();

/*
	tratamento de campos,
	configure conforme sua necessidade,
	siga o exemplo abaixo
*/

/*
	validao,
	coloque aqui estruturas condicionais que
	alimentem o objeto Erro. siga o exemplo abaixo.
*/
$erro = new Erro();
// cliente
if (getParam("f_nome")=="")                         $erro->addErro('Nome do cliente deve ser informado.');
if (getParam("f_tipo_pessoa")=="")                  $erro->addErro('Tipo de pessoa deve ser informado.');
if (getParam("f_documento")=="")                    $erro->addErro('CPF/CNPJ do cliente deve ser informado.');
if (getParam("f_tipo_cli")=="Selecione o tipo")     $erro->addErro('Tipo do cliente deve ser informado.');


if (getParam("f_end_end") == "" or
    getParam("f_end_cep") == "" or
    getParam("f_end_distrito") == "")                $erro->addErro('Endereo incompeto!');
    
if (getParam("f_telefone1") == "" and
    getParam("f_telefone1") == "")                  $erro->addErro('Informe um telefone.');
    
if (getParam("f_email1") == "" and
    getParam("f_email2") == "")                     $erro->addErro('Informe um endereo de e-mail.');


// dominio


// endereo

//if (getParam("f_senha")=="")                 $erro->addErro('Senha deve ser informada.');
//if (strlen(getParam("f_senha"))<6)           $erro->addErro('Senha deve ter 6 ou mais caracteres.');
//if (isDuplicated("usuario", "nome_usuario", "usuario_id", getParam("f_nome_usuario"), getParam("f_id"))) $erro->addErro('Nome de usurio j existe.');
//if (!ereg(REGEX_EMAIL, getParam("f_email"))) $erro->addErro('Endereo de e-mail invlido.');

/*
	Atualizao dos dados, configure abaixo
	conforme suas necessidades
*/
if (!$erro->hasErro()) { // passou na validao
	// objeto para montagem de expresso sql
	$sqlCont    = new UpdateSQL();
	$sqlCli     = new UpdateSQL();
	$sqlDom     = new UpdateSQL();
	$sqlEnd     = new UpdateSQL();
	
	$sqlCont->setTable("contrato");
	$sqlDom->setTable("dominio");
	$sqlCli->setTable("cliente");
	$sqlEnd->setTable("endereco");

	$sqlCont->setKey("cod_contrato",         getParam("f_id"),					           "Number");
	$sqlCli->setKey("cod_cliente",           getParam("f_cod_cliente"),            "Number");
	$sqlDom->setKey("cod_dominio",           getParam("f_cod_dominio"),            "Number");
	$sqlEnd->setKey("cod_endereco",      		 getParam("f_cod_endereco"),           "Number");
	
	
	$sqlCli->addField("dt_nascimento",       $dt_nascimento,                 			 "Date");
	$sqlCli->addField("dt_cadastro",         date("Y-m-d"),                   		 "Date");
	$sqlCli->addField("nome",           	   getParam("f_nome"),    							 "String");
	$sqlCli->addField("email",       				 getParam("f_email"),            			 "String");
	$sqlCli->addField("emailaux",     			 getParam("f_emailaux"),    					 "String");
	$sqlCli->addField("telefone",     			 getParam("f_telefone"),    					 "String");
	$sqlCli->addField("telefoneaux",   			 getParam("f_telefoneaux"),    				 "String");
	$sqlCli->addField("tipo_pessoa",   			 getParam("f_tipo_pessoa"),    				 "String");
	$sqlCli->addField("razao_social",      	 getParam("f_razao_social"),       		 "String");
	$sqlCli->addField("cpf",      	 				 getParam("f_cpf"),       		 				 "String");
	$sqlCli->addField("rg",      	 					 getParam("f_rg"),       		 	 				 "String");
	$sqlCli->addField("indicado",   	       getParam("f_indicado"), 				 			 "String");
	$sqlCli->addField("comentario",          getParam("f_comentario"),           	 "String");
	$sqlCli->addField("cod_usuario", 	 			 1,       		 										 		 "Number");
	$sqlCli->addField("ativo",      	 			 $ativo,       		 										 "Number");

	$sqlDom->addField("dominio",						 getParam("f_dominio"),							   "String");
	$sqlDom->addField("login",						 	 getParam("f_dominio_login"),					 "String");
	$sqlDom->addField("senha",				 			 getParam("f_dominio_senha"),					 "String");
	$sqlDom->addField("webmaster_nome",			 getParam("f_dominio_webmaster"),			 "String");
	$sqlDom->addField("webmaster_email",		 getParam("f_dominio_email"),				   "String");
	$sqlDom->addField("observacoes",				 getParam("f_dominio_observacoes"),		 "String");
	$sqlDom->addField("ativo",      	 			 $dom_ativo,       		 								 "Number");
	
	$sqlEnd->addField("endereco",						 getParam("f_endereco"),							 "String");
	$sqlEnd->addField("numero",						 	 getParam("f_numero"),							   "String");
	$sqlEnd->addField("complemento",				 getParam("f_complemento"),						 "String");
	$sqlEnd->addField("bairro",						 	 getParam("f_bairro"),							   "String");
	$sqlEnd->addField("cidade",						 	 getParam("f_cidade"),							   "String");
	$sqlEnd->addField("cep",						 		 getParam("f_cep"),							       "String");
	$sqlEnd->addField("estado",						 	 getParam("f_estado"),							   "String");
	$sqlEnd->addField("tipo",						 		 "principal",							 						 "String");
	
	
	if (strlen(getParam("f_id"))>0) { // alterao, retirar strlen se vier de edicao_aux
		
		$sqlCont->setAction("UPDATE");
		$sqlCli->setAction("UPDATE");
		$sqlDom->setAction("UPDATE");
    $sqlEnd->setAction("UPDATE");
    
		$sqlCont->addField("cod_contrato",	  	 getParam("f_cod_contrato"),		 			 "Number");
		$sqlCli->addField("cod_cliente",	  		 getParam("f_cod_cliente"),		  			 "Number");
		$sqlDom->addField("cod_dominio",	  		 getParam("f_cod_dominio"),		  			 "Number");
		$sqlEnd->addField("cod_endereco",	  		 getParam("f_cod_endereco"),		 			 "Number");
	
		//$sql->camposControle("UPDATE",dbnow());
		$conn->execute($sqlCont->getSQL());
		$conn->execute($sqlCli->getSQL());
		$conn->execute($sqlDom->getSQL());
		$conn->execute($sqlEnd->getSQL());
		
		$destino = "../admin/cliente_lista.php"; 
	} else { // incluso
		$sqlCont->setAction("INSERT");
		$sqlCli->setAction("INSERT");
		$sqlDom->setAction("INSERT");
		$sqlEnd->setAction("INSERT");
		
    $idCont    = $conn->nextid("contrato");
    $idCli     = $conn->nextid("cliente");
    $idDom     = $conn->nextid("dominio");
    $idEnd     = $conn->nextid("endereco");
		
		$sqlCont->addField("cod_contrato",    $idCont,     					 				 				 "Number");
		$sqlCont->addField("cod_cliente",     $idCli,     					 				 				 "Number");
		$sqlCont->addField("cod_dominio",     $idDom,     					 				 				 "Number");
		
		$sqlCli->addField("cod_cliente",      $idCli,     					 				 				 "Number");

		$sqlDom->addField("cod_dominio",      $idDom,     					 				 				 "Number");

		$sqlEnd->addField("cod_endereco",     $idEnd,     					 				 				 "Number");
		$sqlEnd->addField("cod_cliente",      $idCli,     					 				 				 "Number");
		
		//$sql->camposControle("INSERT",dbnow());
		
		$last_idCont = $conn->execute($sqlCont->getSQL());
		$last_idCli  = $conn->execute($sqlCli->getSQL());
		$last_idDom  = $conn->execute($sqlDom->getSQL());
		$last_idEnd  = $conn->execute($sqlEnd->getSQL());
		$destino = "../admin/cliente_lista.php";
	}

echo	$sqlDom->getSQL();
	// volta para a lista ou reapresenta o formulrio em modo de edio
	redirect($destino,"content");
} else { // no passou na validao
	alert('Ocorreram os seguintes erros!\n\n'.$erro->toString());
}
/*
	Encerra a conexo com o banco de dados
*/
$conn->close();
?>
