<?
/*
	Modelo de pgina que apresenta um formulrio
	para incluso/alterao de registros
*/
include("../inc/common.php");

/*
	verificao do nvel do usurio
*/
verificaPermissaoPagina("10,1");

/*
	estabelece conexo com o banco de dados
*/
$conn = new db();
$conn->open();

/*
	tratamento de campos, caso seja edio.
	configure conforme suas necessidades
*/
$id = getParam("id"); // captura a varivel que veio de objeto_lista
if (strlen($id)>0) { // edio
	$sql = "select cliente.* from contrato, cliente where contrato.cod_contrato = ".$id." and contrato.cod_cliente = cliente.cod_cliente"; 
	$rs = new query($conn, $sql);
	if ($rs->getrow()) {
		$bd_cod_cliente         = $rs->field("cod_cliente");
		$bd_nome                = $rs->field("nome");
		$bd_dt_nascimento       = stod($rs->field("dt_nascimento"));
		$bd_email               = $rs->field("email");
		$bd_emailaux            = $rs->field("emailaux");
		$bd_telefone            = $rs->field("telefone");
		$bd_telefoneaux         = $rs->field("telefoneaux");
		$bd_tipo_pessoa         = $rs->field("tipo_pessoa");
		$bd_razao_social        = $rs->field("razao_social");
		$bd_rg        					= $rs->field("rg");
		$bd_cpf        					= $rs->field("cpf");
		$bd_dt_cadastro         = stod($rs->field("dt_cadastro"));
		$bd_indicado            = $rs->field("indicado");
		$bd_descricao          = $rs->field("comentario");
		$bd_ativo          			= $rs->field("ativo");
		
	}

	$sqlDom = "select dominio.* from contrato, dominio where contrato.cod_contrato = ".$id." and contrato.cod_dominio = dominio.cod_dominio";
	$rsDom = new query($conn,$sqlDom);
	if($rsDom->getrow()){
	  $bd_cod_dominio         = $rsDom->field("cod_dominio");
		$bd_dominio             = $rsDom->field("dominio");
		$bd_login               = $rsDom->field("login");
		$bd_senha               = $rsDom->field("senha");
		$bd_webmaster_nome      = $rsDom->field("webmaster_nome");
		$bd_webmaster_email     = $rsDom->field("webmaster_email");
		$bd_observacoes         = $rsDom->field("observacoes");
		$bd_dom_ativo      			= $rsDom->field("ativo");
	}
	
	$sqlEnd = "SELECT * FROM endereco WHERE cod_cliente = ".$bd_cod_cliente;
	$rsEnd = new query($conn,$sqlEnd);
	if($rsEnd->getrow()){
	  $bd_cod_endereco        = $rsEnd->field("cod_endereco");
		$bd_endereco            = $rsEnd->field("endereco");
		$bd_numero              = $rsEnd->field("numero");
		$bd_complemento         = $rsEnd->field("complemento");
		$bd_bairro              = $rsEnd->field("bairro");
		$bd_cidade              = $rsEnd->field("cidade");
		$bd_cep                 = $rsEnd->field("cep");
		$bd_estado              = $rsEnd->field("estado");
	}
} else {
	$bd_tipo_pessoa = "F";
	$bd_ativo = 1;
	$bd_dom_ativo = 1;
}

// definio da lista para o campo RadioField
$lista_pessoa = array("F,Fsica","J,Jurdica");
?>
<html>
<head>
	<title>cliente-edicao</title>
	<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
	<link rel="stylesheet" type="text/css" href="<?=CSS_CONTENT?>">
	<?=carregaJS("popcalendar,lookup,focus,textcounter,editor");?>
	<script language='JavaScript'>
	/*
		funo que chama a rotina de salvamento,
		altere somente o nome da pgina
	*/
	function salvar() {
		parent.content.document.frm.target = "controle";
		parent.content.document.frm.action = "../admin/cliente_salvar.php";
		parent.content.document.frm.submit();
	}
	
	/*
		exemplo de funo que chama script no frame controle para complementar o
		processamento dos campos no formulrio. normalmente chamado pelo onChange dos
		campos do formulrio.
	*/
	function atualizaCampo(frm) {
		indice = frm.f_campo.selectedIndex;
		localizacao = "cliente_atualizar.php?pesq=" + frm.f_campo.options[indice].value;
		parent.controle.location = localizacao;
	}
	
	/*
		funo que define o foco inicial do formulrio,
		altere conforme o campo do formulrio
	*/
	function inicializa() {
		parent.content.document.frm.f_nome.focus();
	}
	</script>

</head>
<body class="contentBODY" onload="inicializa()">

<?
pageTitle("Cliente","Edio");

/*
	botes de aes,
	configure conforme suas necessidades
*/
$retorno = $_SERVER['QUERY_STRING'];

$button = new Button;
$button->addItem(" Salvar ","javascript:salvar()","content");
$button->addItem(" Fechar ","../admin/cliente_lista.php?$retorno","content");
echo $button->writeHTML();

/*
	Controle de abas,
	true, se for a aba da pgina atual,
	false, se for qualquer outra aba,
	configure conforme o exemplo abaixo

$abas = new Abas();
$abas->addItem("Geral",true);
echo $abas->writeHTML();

echo "<br>";*/

/*
	Formulrio
*/
$form = new Form("frm", "../admin/cliente_salvar.php", "POST", "controle", "100%");
$form->setLabelWidth("20%");
$form->setDataWidth("80%");

$form->addHidden("rodou","s"); // varivel de controle
$form->addHidden("f_id",                $id);
$form->addHidden("f_cod_cliente",       $bd_cod_cliente); 
$form->addHidden("f_cod_endereco",      $bd_cod_endereco);
$form->addHidden("f_cod_dominio",       $bd_cod_dominio);
$form->addHidden("pagina",              getParam("pagina")); // nmero da pgina que chamou

$form->addField("Nome: ",  		  			  textField("f_nome",$bd_nome,50,250));
$form->addField("Data de nascimento: ", dateField("f_dt_nascimento",$bd_dt_nascimento));
$form->addField("Email: ",  			      textField("f_email",$bd_email,50,250));
$form->addField("Email auxiliar: ",     textField("f_emailaux",$bd_emailaux,50,250));
$form->addField("Telefone: ",           textField("f_telefone",$bd_telefone,25,25));
$form->addField("Telefone auxiliar: ",  textField("f_telefoneaux",$bd_telefoneaux,25,25));
$form->addField("Tipo de pessoa: ",     radioField($lista_pessoa,"f_tipo_pessoa",$bd_tipo_pessoa));
$form->addField("Razo Social: ",  			textField("f_razao_social",$bd_razao_social,20,20));
$form->addField("CPF: ",  							textField("f_cpf",$bd_cpf,20,20));
$form->addField("RG: ",  								textField("f_rg",$bd_rg,20,20));
//$form->addField("Data de cadastro: ",  	dateField("f_dt_cadastro",$bd_dt_cadastro,"readonly"));
$form->addField("Indicao: ",  		  	textField("f_indicado",$bd_indicado,50,250));
$form->addField("Comentrios: ",  		  textAreaFieldEditor("f_comentario",$bd_descricao,6,50));
$form->addField("Ativo: ",    					checkboxField("f_ativo",1,$bd_ativo==1, ""));

$form->addBreak("Domnio");
$form->addField("Domnio: ",  		  		textField("f_dominio",$bd_dominio,70,250));
$form->addField("Login: ",  		  			textField("f_dominio_login",$bd_login,20,255));
$form->addField("Senha: ",  		  			textField("f_dominio_senha",$bd_senha,25,255));
$form->addField("Nome do webmaster: ",  textField("f_dominio_webmaster",$bd_webmaster_nome,60,250));
$form->addField("Email do webmaster: ", textField("f_dominio_email",$bd_webmaster_email,60,250));
$form->addField("Observaes: ",  		  textAreaFieldEditor("f_dominio_observacoes",$bd_observacoes,6,50));
$form->addField("Ativo: ",    					checkboxField("f_dom_ativo",1,$bd_dom_ativo==1, ""));

$form->addBreak("Endereo");
$form->addField("Endereo: ",  		  		textField("f_endereco",$bd_endereco,60,250));
$form->addField("Nmero: ",  		  			textField("f_numero",$bd_numero,5,25));
$form->addField("Complemento: ",  		  textField("f_complemento",$bd_complemento,15,25));
$form->addField("Bairro: ",  		  			textField("f_bairro",$bd_bairro,20,80));
$form->addField("Cidade: ",  		  			textField("f_cidade",$bd_cidade,20,80));
$form->addField("CEP: ",  		  			  textField("f_cep",$bd_cep,9,10));
$form->addField("Estado: ",  		  			textField("f_estado",$bd_estado,2,250));

echo $form->writeHTML();
?>
</body>
</html>
<?
/*
	encerra a conexo com o banco de dados
*/
$conn->close();
?>
